<?php
use yii\helpers\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\bootstrap5\Breadcrumbs;

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <style>
        body { padding-top: 70px; font-family: Arial, sans-serif; background:#f8f9fa;}
        .container { max-width: 1200px; margin: auto; }
        .room-card, .service-card { border:1px solid #ddd; border-radius:10px; padding:15px; margin-bottom:20px; transition: transform .3s; background:#fff;}
        .room-card:hover, .service-card:hover { transform:scale(1.03); box-shadow:0 5px 15px rgba(0,0,0,0.2); }
        .navbar-nav .nav-link { margin-right:15px; }
    </style>
</head>
<body>
<?php $this->beginBody() ?>

<?php
NavBar::begin([
        'brandLabel' => 'Отель "Как дома"',
        'brandUrl' => Yii::$app->homeUrl,
        'options' => ['class' => 'navbar navbar-expand-lg navbar-dark bg-dark fixed-top'],
]);

$menuItems = [
        ['label' => 'Главная', 'url' => ['/site/index']],
        ['label' => 'Номера и цены', 'url' => ['/site/rooms']],
];

if (Yii::$app->user->isGuest) {
    $menuItems[] = ['label' => 'Регистрация', 'url' => ['/site/register']];
    $menuItems[] = ['label' => 'Вход', 'url' => ['/site/login']];
} else {
    $menuItems[] = ['label' => 'Мои бронирования', 'url' => ['/booking/index']];
    if (Yii::$app->user->identity->is_admin) {
        $menuItems[] = ['label' => 'Панель админа', 'url' => ['/admin/index']];
    }
    $menuItems[] = '<li>'
            . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-inline'])
            . Html::submitButton('Выйти (' . Yii::$app->user->identity->fio . ')', ['class' => 'btn btn-link logout'])
            . Html::endForm()
            . '</li>';
}

echo Nav::widget([
        'options' => ['class' => 'navbar-nav ms-auto'],
        'items' => $menuItems,
]);
NavBar::end();
?>

<div class="container">
    <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs'] ?? []]) ?>
    <?= $content ?>
</div>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
