<?php

namespace app\models;

use yii\db\ActiveRecord;

class Booking extends ActiveRecord
{
    public static function tableName()
    {
        return 'booking';
    }

    public function rules()
    {
        return [
            [['user_id', 'room_id', 'checkin', 'checkout', 'guests', 'payment_type'], 'required'],
            ['guests', 'integer', 'min' => 1],
            ['additional_services', 'string'],
            ['payment_type', 'in', 'range' => ['Наличные', 'Карта']],
            ['status', 'default', 'value' => 'Новое'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'Пользователь',
            'room_id' => 'Комната',
            'checkin' => 'Дата заезда',
            'checkout' => 'Дата выезда',
            'guests' => 'Количество гостей',
            'additional_services' => 'Дополнительные услуги',
            'payment_type' => 'Тип оплаты',
            'status' => 'Статус',
            'created_at' => 'Дата бронирования',
            'updated_at' => 'Дата обновления',
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getRoom()
    {
        return $this->hasOne(Room::class, ['id' => 'room_id']);
    }
}
