<?php
namespace app\controllers;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Booking;
use app\models\Room;

class BookingController extends Controller
{
    public function behaviors()
    {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'only'=>['index','create'],
                'rules'=>[
                    ['allow'=>true,'roles'=>['@']],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $bookings = Booking::find()->where(['user_id'=>Yii::$app->user->id])->all();
        return $this->render('index',['bookings'=>$bookings]);
    }

    public function actionCreate()
    {
        $model = new Booking();
        $rooms = Room::find()->all();

        if($model->load(Yii::$app->request->post())){
            $model->user_id = Yii::$app->user->id;
            $model->status = 'Новое';
            if($model->save()){
                Yii::$app->session->setFlash('success','Заявка создана');
                return $this->redirect(['index']);
            }
        }

        return $this->render('create',['model'=>$model,'rooms'=>$rooms]);
    }
}
